package cn.com.duiba.supplier.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @date:2022/1/7 11:40
 * @author:zhaozhanghai
 * @Description:
 */
public class DuibaLiveSupplierDto implements Serializable {


    private static final long serialVersionUID = 73861846586514878L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 供应商名
     */
    private String supplierName;

    /**
     * 供应商简称
     */
    private String supplierShortName;

    /**
     * 联系人
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 经营类目goodsType 1-实物 2-卡券 3-虚拟商品  [{type:1,itemClassifyId:[{id:1,name:食品酒水}]},{type:2}]
     */
    private String businessCategory;

    /**
     * 供应商状态:0关闭1开启
     */
    private Integer supplierState;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 登录名
     */
    private String loginAccount;

    /**
     * 登陆密码
     */
    private String loginPassword;

    /**
     * 是否包含跨境商品 0-不包含 1-包含
     */
    private Integer isCross;

    /**
     * 宝付通商户号 仅pop商户使用
     */
    private String bftMerchant;

    /**
     * 宝付通终端号 仅pop商户使用
     */
    private String bftTerminal;

    /**
     * 宝付通跨境 仅pop商户使用
     */
    private String bftCross;

    /**
     * 供应商类型 0-自营 1-pop
     */
    private Integer supplierType;

    /**
     * 是否缴纳保证金 0-未缴纳 1-已缴纳
     */
    private Integer isPayBond;

    /**
     * 供应商资质图片url  http://1.jpg,http://2.jpg
     */
    private String supplierQualifications;

    /**
     * 类目资质图片url  http://1.jpg,http://2.jpg
     */
    private String categoryQualifications;


    /**
     * 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 供应商名
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 供应商简称
     */
    public String getSupplierShortName() {
        return supplierShortName;
    }

    /**
     * 供应商简称
     */
    public void setSupplierShortName(String supplierShortName) {
        this.supplierShortName = supplierShortName;
    }

    /**
     * 联系人
     */
    public String getContactName() {
        return contactName;
    }

    /**
     * 联系人
     */
    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    /**
     * 联系电话
     */
    public String getContactPhone() {
        return contactPhone;
    }

    /**
     * 联系电话
     */
    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    /**
     * 经营类目goodsType 1-实物 2-卡券 3-虚拟商品  [{type:1,itemClassifyId:[{id:1,name:食品酒水}]},{type:2}]
     */
    public String getBusinessCategory() {
        return businessCategory;
    }

    /**
     * 经营类目goodsType 1-实物 2-卡券 3-虚拟商品  [{type:1,itemClassifyId:[{id:1,name:食品酒水}]},{type:2}]
     */
    public void setBusinessCategory(String businessCategory) {
        this.businessCategory = businessCategory;
    }

    /**
     * 供应商状态:0关闭1开启
     */
    public Integer getSupplierState() {
        return supplierState;
    }

    /**
     * 供应商状态:0关闭1开启
     */
    public void setSupplierState(Integer supplierState) {
        this.supplierState = supplierState;
    }

    /**
     * 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 登录名
     */
    public String getLoginAccount() {
        return loginAccount;
    }

    /**
     * 登录名
     */
    public void setLoginAccount(String loginAccount) {
        this.loginAccount = loginAccount;
    }


    /**
     * 是否包含跨境商品 0-不包含 1-包含
     */
    public Integer getIsCross() {
        return isCross;
    }

    /**
     * 是否包含跨境商品 0-不包含 1-包含
     */
    public void setIsCross(Integer isCross) {
        this.isCross = isCross;
    }

    /**
     * 宝付通商户号 仅pop商户使用
     */
    public String getBftMerchant() {
        return bftMerchant;
    }

    /**
     * 宝付通商户号 仅pop商户使用
     */
    public void setBftMerchant(String bftMerchant) {
        this.bftMerchant = bftMerchant;
    }

    /**
     * 宝付通终端号 仅pop商户使用
     */
    public String getBftTerminal() {
        return bftTerminal;
    }

    /**
     * 宝付通终端号 仅pop商户使用
     */
    public void setBftTerminal(String bftTerminal) {
        this.bftTerminal = bftTerminal;
    }

    /**
     * 宝付通跨境 仅pop商户使用
     */
    public String getBftCross() {
        return bftCross;
    }

    /**
     * 宝付通跨境 仅pop商户使用
     */
    public void setBftCross(String bftCross) {
        this.bftCross = bftCross;
    }

    /**
     * 供应商类型 0-自营 1-pop
     */
    public Integer getSupplierType() {
        return supplierType;
    }

    /**
     * 供应商类型 0-自营 1-pop
     */
    public void setSupplierType(Integer supplierType) {
        this.supplierType = supplierType;
    }

    /**
     * 是否缴纳保证金 0-未缴纳 1-已缴纳
     */
    public Integer getIsPayBond() {
        return isPayBond;
    }

    /**
     * 是否缴纳保证金 0-未缴纳 1-已缴纳
     */
    public void setIsPayBond(Integer isPayBond) {
        this.isPayBond = isPayBond;
    }

    /**
     * 供应商资质图片url  http://1.jpg,http://2.jpg
     */
    public String getSupplierQualifications() {
        return supplierQualifications;
    }

    /**
     * 供应商资质图片url  http://1.jpg,http://2.jpg
     */
    public void setSupplierQualifications(String supplierQualifications) {
        this.supplierQualifications = supplierQualifications;
    }

    /**
     * 类目资质图片url  http://1.jpg,http://2.jpg
     */
    public String getCategoryQualifications() {
        return categoryQualifications;
    }

    /**
     * 类目资质图片url  http://1.jpg,http://2.jpg
     */
    public void setCategoryQualifications(String categoryQualifications) {
        this.categoryQualifications = categoryQualifications;
    }

    public String getLoginPassword() {
        return loginPassword;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }
}
