package cn.com.duiba.supplier.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 兑吧直播供应商订单dto
 * @author zhanghuifeng
 * @date 2022/1/8 10:34
 */
@Data
public class DuibaLiveSupplierOrderDto implements Serializable {
    /**
     * 订单ID
     */
    private Long id;

    /**
     *
     */
    private Long version;

    /**
     * 开发者成本价
     */
    private Integer actualPrice;

    /**
     * appid
     */
    private Long appId;

    /**
     * 业务参数，如实物订单则为收货信息
     */
    private String bizParams;

    /**
     * 订单概述
     */
    private String brief;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 开发者id
     */
    private Long developerId;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * sku划线价单位分
     */
    private Integer facePrice;

    /**
     * 订单完成时间
     */
    private Date finishTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 兑吧商品id
     */
    private Long itemId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 支付状态（开发者维度） none不需要支付  prereduce预扣 payback冲正
     */
    private String payStatus;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 订单状态consume_success用户已付款，fail失败，success成功
     */
    private String status;

    /**
     * 商品类型
     */
    private String type;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 兑换类型 mall普兑
     */
    private String chargeMode;

    /**
     * 失败类型 0-成功 1-上游失败 2-开发者服务器异常 3-开发者反馈失败 4审核拒绝
     */
    private Integer failType;

    /**
     * 订单进入待发货的时间
     */
    private Date lastSendTime;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 开发者商品id
     */
    private Long appItemId;

    /**
     * 使用GoodsTypeEnum的gtype类型常量
     */
    private Integer typeInt;

    /**
     * 订单状态值
     */
    private Integer statusInt;

    /**
     * 审核状态值
     */
    private Integer auditStatusInt;

    /**
     * 支付状态值
     */
    private Integer payStatusInt;

    /**
     * 关联订单的id 普兑时为空
     */
    private Long relationId;

    /**
     * 关联订单的类型 0普兑
     */
    private Integer relationType;

    /**
     * 兑吧扣款状态: none, unkonw_pay, prereduce, success, payback
     */
    private String duibaPayStatus;

    /**
     * 兑吧成本价
     */
    private Integer duibaActualPrice;

    /**
     * 子订单ID
     */
    private Long subOrderId;

    /**
     * 子订单类型 amb:加钱购
     */
    private String subOrderType;

    /**
     * 用户付款状态: none,wait_pay,pay_success,pay_back,canceled,success
     */
    private String consumerPayStatus;

    /**
     * 用户支付金额
     */
    private Long consumerPayPrice;

    /**
     * 用户退款金额
     */
    private Long consumerPayBackPrice;

    /**
     * 流程中转状态
     */
    private String flowworkStage;

    /**
     * 订单额外信息
     */
    private String extraInfo;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 兑吧主订单ID
     */
    private Long duibaOrdersId;

}
