package cn.com.duiba.supplier.center.api.dto.sku;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Desc SKU规格属性链，树形结构
 * @Author xuwei
 * @Date 2018/11/6
 */
@Data
public class SkuAttributeNode<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = 4889249887035984312L;

    /**
     * 属性id
     */
    private String id;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 规格id, 实际是spec id
     */
    private String specId;

    /**
     * 销售信息（T可能为SKU信息）
     */
    private T skuInfo;

    /**
     * 子属性列表
     */
    private List<SkuAttributeNode<T>> children;

}
