package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierOrderDto;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierOrderPageDto;
import cn.com.duiba.supplier.center.api.params.DuibaLiveSupplierOrderPageParam;

import java.util.List;

/**
 * 兑吧直播供应商订单remote
 * @author zhanghuifeng
 * @date 2022/1/8 10:33
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierOrderService {

    /**
     * 插入订单
     * @param dto 订单属性
     * @return 兑吧直播供应商订单ID （为空时则插入失败）
     */
    Long insert(DuibaLiveSupplierOrderDto dto);

    /**
     * 根据兑吧主订单ID更新订单属性
     * @param dto 订单属性（duibaOrdersId不能为空）
     * @return 更新结果
     */
    Boolean updateByDuibaOrdersId(DuibaLiveSupplierOrderDto dto);


    /**
     * 订单分页
     * @param duibaLiveSupplierOrderPageParam
     * @return
     */
    DuibaLiveSupplierOrderPageDto page(DuibaLiveSupplierOrderPageParam duibaLiveSupplierOrderPageParam);

    /**
     * 根据兑吧主订单ID查询兑吧直播供应商订单信息
     * @param duibaOrderId 兑吧订单ID
     * @return 兑吧直播供应商信息
     */
    DuibaLiveSupplierOrderDto findByDuibaOrderId(Long duibaOrderId);

    /**
     * 根据兑吧主订单ID集合查询兑吧直播供应商订单信息
     * @param duibaOrderIds 兑吧订单ID
     * @return 兑吧直播供应商信息
     */
    List<DuibaLiveSupplierOrderDto> listByDuibaOrderIds(List<Long> duibaOrderIds);

}
