package cn.com.duiba.supplier.center.api.params;

import cn.com.duiba.supplier.center.api.base.BasePage;

import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/1/7 11:42
 * @author:zhaozhanghai
 * @Description:
 */
public class DuibaLiveSupplierOrderPageParam extends BasePage implements Serializable {
    private static final long serialVersionUID = -6917733927527253841L;
    /**
     * 订单号
     */
    private String orderNum;
    /**
     * 商品备注
     */
    private String itemDesc;
    /**
     * 下单开始时间 yyyy-MM-dd
     */
    private String startTime;
    /**
     * 下单结束时间 yyyy-MM-dd
     */
    private String endTime;
    /**
     * 供应商类型 0-自营 1-pop
     */
    private String supplierType;
    /**
     * 订单状态
     * none
     * wait_pay
     * pay_success
     * pay_back
     * canceled
     * success
     */
    private String status;
    /**
     * 关联订单的类型
     * 0=普通订单
     * 1=专题活动订单
     * 2=单品抽奖
     * 3=大转盘订单
     * 4=手动开奖
     * 5=活动工具
     * 6=游戏活动
     * 7=秒杀专题
     * 8=答题活动
     * 10=测试题活动
     * 9=秒杀活动
     * 11=新游戏
     * 12=竞猜活动
     * 13=今日必抢
     * 14=积分游戏
     * 15=小游戏
     * 16=插件活动
     * 17=弹层活动
     * 18=签到活动
     */
    private String relationType;
    /**
     * 商品名
     */
    private String itemName;

    /**
     * 商品备注
     */
    private String itemRemark;
    /**
     * 商品类型
     */
    private String itemType;

    /**
     * 供应商id
     */
    private Long supplierId;


    /**
     * 兑吧商品ids
     */
    private List<Long> duibaItemIds;

    public DuibaLiveSupplierOrderPageParam() {
        super.setPageSize(20L);
        super.setPageNo(1L);
    }

    public String getItemRemark() {
        return itemRemark;
    }

    public void setItemRemark(String itemRemark) {
        this.itemRemark = itemRemark;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getSupplierType() {
        return supplierType;
    }

    public void setSupplierType(String supplierType) {
        this.supplierType = supplierType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }



    public List<Long> getDuibaItemIds() {
        return duibaItemIds;
    }

    public void setDuibaItemIds(List<Long> duibaItemIds) {
        this.duibaItemIds = duibaItemIds;
    }
}
