package cn.com.duiba.supplier.center.api.remoteservice.sku;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierGoodsSkuDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/01/10 14:03
 * @description 商品Sku - RPC服务
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveGoodsSkuService {

    /**
     * 批量更新统一商品下的sku
     *
     * @param goodsId      商品Id
     * @param goodsSkuList 商品Sku列表
     * @return 更新结果
     */
    int batchUpdateByGoodsId(Long goodsId, List<DuibaLiveSupplierGoodsSkuDto> goodsSkuList);

}
