package cn.com.duiba.supplier.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 兑吧直播供应商售后订单dto
 * @author zhanghuifeng
 * @date 2022/1/8 10:42
 */
@Data
public class DuibaLiveSupplierPostsaleOrderDto implements Serializable {
    private static final long serialVersionUID = 3846726528091995186L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 售后状态:
     wait:待售后,
     refunding:退款中,
     reject:拒绝售后,
     canceled:取消售后,
     agree:同意售后 处理中,
     success:售后成功
     */
    private String postsaleStatus;

    /**
     * 兑吧主订单ID
     */
    private Long duibaOrdersId;

    /**
     * 兑吧主订单号
     */
    private String duibaOrderNum;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 加钱购子订单ID
     */
    private Long ambSubOrdersId;

    /**
     * 支付通道订单ID
     */
    private Long ambPaychannelOrdersId;

    /**
     * 售后发起金额
     */
    private Long postsaleMoney;

    /**
     * 用户备注
     */
    private String consumerRemark;

    /**
     * 操作备注
     */
    private String operateRemark;

    /**
     * 联系人
     */
    private String contactPerson;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 处理时间 同意/拒绝 的时间
     */
    private Date operateTime;

    /**
     * 完成时间 开发者点击完成售后的时间
     */
    private Date finishTime;

    /**
     * 操作日志
     */
    private String operateLog;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 售后订单用户上传的图片JSON数组
     */
    private String pictureUrls;

    /**
     * 售后订单标识
     */
    private Long postsaleOrderNum;

    /**
     * 主订单子订单号
     */
    private Long ordersItemId;

    /**
     * 售后类型,1:换货;2:退货已收到货;3:退货未收到货兼容以前的售后;
     */
    private Integer postsaleType;

    /**
     * 供应商id
     */
    private Long supplierInfoId;

    /**
     * 售后发起积分
     */
    private Long postsaleCredits;

    /**
     * 版本号
     */
    private Integer version;

    /**
     * 售后发起原因
     */
    private String postsaleReason;

    /**
     * 货物状态，0未收到，1已收到
     */
    private Integer goodsStatus;

    /**
     * 兑吧售后订单ID
     */
    private Long duibaPostsaleOrderId;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 商品备注
     */
    private String itemRemark;
}
