package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierPostsaleOrderDto;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierPostsaleOrderPageDto;
import cn.com.duiba.supplier.center.api.params.DuibaLiveSupplierPostsaleOrderPageParam;

/**
 * 兑吧直播供应商售后订单remote
 * @author zhanghuifeng
 * @date 2022/1/8 10:33
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierPostsaleOrderService {

    /**
     * 插入售后订单
     * @param dto 订单属性
     * @return 兑吧直播供应商售后订单ID （为空时则插入失败）
     */
    Long insert(DuibaLiveSupplierPostsaleOrderDto dto);

    /**
     * 根据兑吧售后订单ID更新售后订单属性
     * @param dto 售后订单属性（duibaPostsaleOrderId不能为空）
     * @return 更新结果
     */
    Boolean updateByDuibaPostsaleOrderId(DuibaLiveSupplierPostsaleOrderDto dto);


    DuibaLiveSupplierPostsaleOrderPageDto page(DuibaLiveSupplierPostsaleOrderPageParam param);

    /**
     * 根据兑吧售后订单ID查询
     * @param duibaPostsaleOrderId 兑吧售后订单ID
     * @return 兑吧直播售后订单信息
     */
    DuibaLiveSupplierPostsaleOrderDto findByDuibaPostsaleOrderId(Long duibaPostsaleOrderId);

}
