package cn.com.duiba.supplier.center.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuibaLiveSupplierGoodsDto;
import cn.com.duiba.supplier.center.api.params.goods.DuibaLiveSupplierGoodsQueryParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/01/10 14:03
 * @description 商品相关 RPC
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveGoodsService {

    /**
     * 新增商品
     *
     * @param goodsDto 商品详情
     * @return 商品Id
     */
    Long insert(DuibaLiveSupplierGoodsDto goodsDto);

    /**
     * 更新商品
     *
     * @param goodsDto 商品详情
     * @return 更新结果
     */
    int update(DuibaLiveSupplierGoodsDto goodsDto);

    /**
     * 分页查询列表
     *
     * @param param 查询参数
     * @return 测试列表
     */
    List<DuibaLiveSupplierGoodsDto> listByParam(DuibaLiveSupplierGoodsQueryParam param);

    /**
     * 查询记录的总记录数
     *
     * @param param 查询参数
     * @return 总记录数
     */
    Long countByParam(DuibaLiveSupplierGoodsQueryParam param);

}
