package cn.com.duiba.kjy.api.api.bean.wxpay.request;

import cn.com.duiba.kjy.api.api.annotation.FieldMapKey;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 微信企业付款到零钱查询参数
 * @author lizhi
 * @date 2020/4/1 3:48 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxPayCompanyQueryRequest extends BaseWxRequest {

    private static final long serialVersionUID = 7989671732916370504L;

    /**
     * 商户账号appid
     * String(128)
     */
    @FieldMapKey("appid")
    @NotNull(message = "mchAppId must not be null")
    @Size(max = 128, message = "appId过长")
    private String mchAppId;

    /**
     * 微信支付分配的商户号
     * String(32)
     */
    @FieldMapKey("mch_id")
    @NotNull(message = "mchId must not be null")
    @Size(max = 32, message = "商户id过长")
    private String mchId;

    /**
     * 商户订单号，需保持唯一性
     * String(32)
     */
    @FieldMapKey("partner_trade_no")
    @NotNull(message = "partnerTradeNo must not be null")
    @Size(max = 32, message = "partnerTradeNo过长")
    private String partnerTradeNo;
}