package cn.com.duiba.kjy.api.api.bean.wxpay.result;

import cn.com.duiba.kjy.api.api.annotation.FieldMapKey;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2020/4/1 3:32 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxPayCompanyQueryResult extends BaseWxResult {

    private static final long serialVersionUID = 5346503173379523554L;

    /**
     * 商户订单号
     * String(32)
     */
    @FieldMapKey("partner_trade_no")
    private String partnerTradeNo;

    /**
     * 转账状态
     * string(16)
     *
     * SUCCESS:转账成功
     * FAILED:转账失败
     * PROCESSING:处理中
     */
    @FieldMapKey("status")
    private String status;

    /**
     * 如果失败则有失败原因
     * String(128)
     */
    @FieldMapKey("reason")
    private String reason;

    /**
     * 企业付款成功时间
     * String(32)
     * 2015-05-19 15:26:59
     */
    @FieldMapKey("payment_time")
    private String paymentTime;
}