package cn.com.duiba.kjy.api.api.dto.wechat;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户代码审核记录
 * @Author xujing
 * @Date 2021/1/27 11:37 上午
 */
@Data
public class WxAuthorizerTemplateDto implements Serializable {

    private static final long serialVersionUID = 4237428251086778533L;
    /**
    * 主键
    */
    private Long id;

    /**
    * appId
    */
    private String appId;

    /**
    * 模板id
    */
    private Long templateId;

    /**
    * 审核id
    */
    private Long auditId;

    /**
    * 版本
    */
    private String userVersion;

    /**
    * 描述
    */
    private String userDesc;

    /**
    * 类型
     * @see cn.com.duiba.kjy.api.api.enums.wechat.TemplateTypeEnum
    */
    private Integer templateType;

    /**
    * 状态
     * @see cn.com.duiba.kjy.api.api.enums.wechat.TemplateStatusEnum
    */
    private Integer templateStatus;

    /**
    * 失败原因
    */
    private String failReason;

    /**
    * gmtCreate
    */
    private Date gmtCreate;

    /**
    * gmtModified
    */
    private Date gmtModified;

    /**
     * 提审时间
     */
    private Date auditTime;

    /**
     * 代码提交时间
     */
    private Date submitTime;

    /**
     * 上线时间
     */
    private Date onlineTime;

    /**
     * 页面路径
     */
    private String pagePath;

    /**
     * 版本回退 0未回退 1已回退
     */
    private Integer versionBack;
}