package cn.com.duiba.kjy.api.api.dto.wechat.coupon;

import cn.com.duiba.kjy.api.api.enums.wechat.coupon.UserCouponStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户优惠券领取记录
 * @Author xujing
 * @Date 2021/7/28 11:38 上午
 */
@Data
public class WxPayUserCouponRecordDto implements Serializable {

    private static final long serialVersionUID = -7713241138348597014L;
    /**
     * id
     */
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * openId
     */
    private String openId;

    /**
     * 兑吧侧 批次id 主键 非微信批次id
     */
    private Long stockId;

    /**
     * 商户此次发放凭据号（格式：商户id+日期+流水号）
     */
    private String outRequestNo;

    /**
     * wx侧优惠券id
     */
    private String wxCouponId;

    /**
     * @see UserCouponStatusEnum
     * 优惠券状态 0领取,1使用,2过期
     */
    private Integer couponStatus;

    /**
     * 冗余一个优惠券过期时间
     */
    private Date availableEndTime;

    /**
     * json格式的额外优惠券使用信息
     */
    private String extraInfo;

    /**
     * 支付订单号
     */
    private String payOrderNo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 微信侧批次id
     */
    private String wxStockId;

    /**
     * 使用时间
     */
    private Date useTime;

    /**
     * 修改时间
     */
    private Date refundTime;
}