package cn.com.duiba.kjy.api.api.dto.wxmessage.customer;

import cn.com.duiba.kjy.api.api.dto.wxmessage.BaseMessageDto;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * Created by dugq on 2020-02-06.
 * 客服卡片消息
 */
@Data
public class CustomerCardDto extends BaseMessageDto {
    private static final long serialVersionUID = 4561083759648354156L;


    /**
     * 标题
     */
    @NotBlank(message = "卡片消息标题为空")
    private String title;
    /**
     * 描述
     */
    @NotBlank(message = "卡片消息描述不能为空")
    private String desc;

    /**
     * 卡片跳转地址
     */
    @NotBlank(message = "卡片消息的卡片跳转地址不能为空")
    private String url;

    /**
     * 卡片内部图片的第三方文件地址
     */
    @NotBlank(message = "卡片消息的图片地址不能为空")
    private String picUrl;
}
