package cn.com.duiba.kjy.api.api.dto.wxmessage.result;

import lombok.Data;

import java.util.Date;

/**
 * Created by dugq on 2020-03-11.
 */
@Data
public class TemporaryMaterialResult extends WechatResultBean {
    private static final long serialVersionUID = -3054011539614926440L;

    /**
     * 素材类型
     */
    private String type;
    /**
     * 媒体ID
     */
    private String mediaId;
    /**
     * 上传时间
     */
    private Date createdTime;
    /**
     * 失效时间
     */
    private Date disableTime;

    /**
     * 公众号ID
     */
    private Long oaId;


    public static TemporaryMaterialResult buildResponseError(){
        TemporaryMaterialResult wechatResultBean = new TemporaryMaterialResult();
        wechatResultBean.setErrcode(-7L);
        wechatResultBean.setErrmsg("请求结果并非期望值");
        return wechatResultBean;
    }

    public static TemporaryMaterialResult paramError(){
        TemporaryMaterialResult wechatResultBean = new TemporaryMaterialResult();
        wechatResultBean.setErrcode(-5L);
        wechatResultBean.setErrmsg("参数错误");
        return wechatResultBean;
    }

    public static TemporaryMaterialResult httpError(){
        TemporaryMaterialResult wechatResultBean = new TemporaryMaterialResult();
        wechatResultBean.setErrcode(-6L);
        wechatResultBean.setErrmsg("httpclient 发送请求时错误");
        return wechatResultBean;
    }
}
