package cn.com.duiba.kjy.api.api.enums.wechat;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2022/1/17.
 */
@Getter
public enum MessageEventEnum {

    USER_AUTHORIZATION_REVOKE(1, "user_authorization_revoke", "用户撤回"),
    USER_INFO_MODIFIED(2, "user_info_modified", "用户资料变更");

    private final Integer code;

    private final String  type;

    private final String  desc;

    MessageEventEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static MessageEventEnum getByCode(Integer code) {
        return Stream.of(MessageEventEnum.values())
                     .filter(e -> e.getCode()
                                   .equals(code))
                     .findFirst()
                     .orElse(USER_AUTHORIZATION_REVOKE);
    }

    public static MessageEventEnum getByType(String type) {
        return Stream.of(MessageEventEnum.values())
                     .filter(e -> e.getType()
                                   .equals(type))
                     .findFirst()
                     .orElse(USER_AUTHORIZATION_REVOKE);
    }
}