package cn.com.duiba.kjy.api.api.dto.wxmessage.wrapper;

import cn.com.duiba.kjy.api.api.dto.wxmessage.BaseMessageDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.innerlog.WxSendEmbedDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.pushtask.PushTaskDto;
import cn.com.duiba.kjy.api.api.dto.wxmessage.template.TemplateMessageDto;
import cn.com.duiba.kjy.api.api.enums.DegradedTypeEnum;
import cn.com.duiba.kjy.api.api.enums.MessageTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by dugq on 2020-02-07.
 * 消息的封装类
 */
@Data
public class WxMessageWrapperDto<T extends BaseMessageDto> implements Serializable {
    private static final long serialVersionUID = 2301019230465516410L;
    /**
     * 消息类型 {@link cn.com.duiba.kjy.api.api.enums.MessageTypeEnum}
     */
    protected Integer messageType;

    /**
     * 消息体
     */
    @NotNull(message = "消息体不能为空")
    protected T messageDto;

    /**
     * 优先选择user对象的oaID
     * 接受消息的目标公众号
     */
    @NotNull(message = "接受消息的公众号不能为空")
    protected Long oaId;

    /**
     * 推送事件
     */
    protected WxSendEmbedDto wxSendEmbedBean;

    /**
     * 降级策略
     * @see cn.com.duiba.kjy.api.api.enums.DegradedTypeEnum
     */
    @NotNull(message = "降级策略不能为空")
    private Integer degradedType = DegradedTypeEnum.DISCARD.getCode();

    /**
     * 降级消息
     * 可以选择其他任意类型的消息
     * 如切换成模版消息，发送其他公众号或者小程序等等
     */
    protected WxMessageWrapperDto degradedMessageWrapperDto;

    /**
     * 如何降级消息的oaID和推送事件都和推送事件不变，仅仅是推送模版消息时，可以直接追加
     * 符合大部分情况，提供简单追加降级方案的方法
     * 不可以换人推送
     * @param degradedMessageDto 降级模版消息
     */
    public void adddegradedTemplateMessageDto(TemplateMessageDto degradedMessageDto){
        degradedMessageWrapperDto = new WxMessageWrapperDto();
        degradedMessageWrapperDto.setMessageType(MessageTypeEnum.TEMPLATE.getCode());
        this.degradedType = DegradedTypeEnum.OTHER_MESSAGE.getCode();
        degradedMessageWrapperDto.setDegradedType(DegradedTypeEnum.DISCARD.getCode());
        degradedMessageWrapperDto.setMessageDto(degradedMessageDto);
    }

    /**
     * 是否需要推送结果
     * 如果该参数是true  会通过mq 发送推送结果到livecenter
     * 统计推送成功与失败
     */
    protected Boolean needPushResult;

    /**
     * 推送任务对象
     */
    protected PushTaskDto pushTaskDto;
}
