package cn.com.duiba.kjy.api.api.enums.wechat.coupon;

import lombok.Getter;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * 代金券状态枚举
 *
 * @Author xujing
 * @Date 2021/7/28 2:03 下午
 */
@Getter
public enum UserCouponStatusEnum {
    RECEIVED(0, "领取"),
    USED(1, "使用"),
    OVERDUE(2, "过期"),
    REFUNDING(3, "退款中"),
    REFUNDED(4, "退款成功"),
    REFUND_FAIL(5, "退款失败"),
    ;
    private Integer status;

    private String desc;

    UserCouponStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private static Map<Integer, String> map = new HashMap<>();

    static {
        for (UserCouponStatusEnum userCouponStatusEnum : EnumSet.allOf(UserCouponStatusEnum.class)) {
            map.put(userCouponStatusEnum.getStatus(), userCouponStatusEnum.getDesc());
        }
    }

    public static String getByStatus(Integer status) {
        return map.get(status);
    }
}
