package cn.com.duiba.kjy.api.api.remoteservice.wechat.coupon;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.coupon.WxPayCouponStockDto;
import cn.com.duiba.kjy.api.api.param.wechat.coupon.CouponStockSearchParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/7/28 2:49 下午
 */
@AdvancedFeignClient
public interface RemoteWxPayCouponStockService {

    /**
     * 新增一个代金券活动
     * 调用微信接口新增，成功后插入数据库
     *
     * @throws BizException
     */
    void addCouponStock(WxPayCouponStockDto wxPayCouponStockDto) throws BizException;

    /**
     * 启用优惠券批次
     *
     * @param id
     */
    void startCouponStock(Long id) throws BizException;

    /**
     * 禁用优惠券批次
     *
     * @param id
     */
    void stopCouponStock(Long id) throws BizException;

    /**
     * 查询列表
     * @param couponStockSearchParam
     * @return
     */
    List<WxPayCouponStockDto> listByParam(CouponStockSearchParam couponStockSearchParam);

    /**
     * 查询数量
     * @param couponStockSearchParam
     * @return
     */
    Integer countByParam(CouponStockSearchParam couponStockSearchParam);

    /**
     * 查询单个详情
     * @param id
     * @return
     */
    WxPayCouponStockDto findById(Long id);

    /**
     * 批量删除
     * @param ids
     * @return
     */
    Integer batchDelete(List<Long> ids);

    /**
     * 根据商品id查询商品对应的优惠券批次信息
     * 如果批次已过期或者未开启则返回null
     * @param goodsId
     * @return
     */
    WxPayCouponStockDto findByGoodsId(String goodsId);
}
