package cn.com.duiba.duiba.qutui.center.api.dto.task;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName UserData.java
 * @Description 客户数据
 * @createTime 2021年03月18日 20:24:00
 */
@Data
public class UserData implements Serializable {

    private String finishText;

    private String finishUnit;


    public String check() {
        if (StringUtils.isBlank(finishText)) {
            return "请填写完成结果文案";
        }
        if (StringUtils.isBlank(finishUnit)) {
            return "请填写完成单位";
        }
        return null;
    }


    public static UserData json2Obj(String json) {
        try {
            return JSON.parseObject(json, UserData.class);
        } catch (Exception e) {
            return null;
        }
    }
}
