package cn.com.duiba.duiba.qutui.center.api.dto.task;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName EventData.java
 * @Description 时间数据
 * @createTime 2021年03月18日 20:02:00
 */
@Data
public class EventData implements Serializable {

    /**
     * 是否统计参与人数
     */
    private Boolean joinPeopleNum = false;
    private String joinPeopleNumText;
    /**
     * 是否统计参与次数
     */
    private Boolean joinNum = false;
    private String joinNumText;
    /**
     * 是否统计完成人数
     */
    private Boolean finishJoinPeopleNum = false;
    private String finishJoinPeopleNumText;
    /**
     * 是否统计完成次数
     */
    private Boolean finishJoinNum = false;
    private String finishJoinNumText;
    /**
     * 是否统计自然流量
     */
    private Boolean isStatistical;

    public String check() {
        if (joinPeopleNum == null) {
            joinPeopleNum = false;
        }
        if (joinNum == null) {
            joinNum = false;
        }
        if (finishJoinPeopleNum == null) {
            finishJoinPeopleNum = false;
        }
        if (finishJoinNum == null) {
            finishJoinNum = false;
        }
        if (isStatistical == null) {
            isStatistical = false;
        }

        if (!joinPeopleNum && !finishJoinNum) {
            return "参与人数与完成人数必须选择一个!";
        }
        return null;
    }

    public static EventData json2Obj(String json) {
        try {
            return JSON.parseObject(json, EventData.class);
        } catch (Exception e) {
            return null;
        }
    }
}
