/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.qutui.center.api.enums;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum ContentTypeEnum {
    ARTICLE("article", "\u6587\u7ae0"),
    ACTIVITY("activity", "\u6d3b\u52a8"),
    CARD_PRODUCT("card_product", "\u540d\u7247\u4ea7\u54c1"),
    CARD_ACTIVITY("card_activity", "\u540d\u7247\u6d3b\u52a8"),
    CARD_INFO("card_info", "\u4f01\u4e1a\u8d44\u8baf"),
    TASK("task", "\u4efb\u52a1"),
    CARD("card", "\u540d\u7247");

    private String code;
    private String desc;
    private static final Map<String, ContentTypeEnum> ENUM_MAP;

    private ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ARTICLE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.CARD.code);
    }

    public static boolean isTask(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.TASK.code);
    }

    static {
        ENUM_MAP = new HashMap<String, ContentTypeEnum>();
        for (ContentTypeEnum type : ContentTypeEnum.values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }
}

