package cn.com.duiba.duiba.qutui.center.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.content.StaffContentDto;

import java.util.List;

/**
* 销售员的转载内容表 RemoteService
* @author xiaotian
* 2021-3-17 13:38:43
*/
@AdvancedFeignClient
public interface RemoteStaffContentService {
    /**
    * 新增记录
    */
	Long save(StaffContentDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(StaffContentDto dto);
    /**
    * 根据id获取
    */
    StaffContentDto getById(Long id);
    /**
     * 获取内容列表
     * @param ids
     * @return
     */
    List<StaffContentDto> getList(List<Long> ids);

    /**
     * 通过员工和内容类型，获取
     * @param staffId
     * @param contentType
     * @return
     */
    StaffContentDto getStaffIdAndContentTypeLast(Long staffId,String contentType);
}
