package cn.com.duiba.duiba.qutui.center.api.result.task;

import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectPushJsonDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.SetupGradeDetailDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.SetupGradeDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.StaffEventGradeDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.StaffGradeDto;
import com.alibaba.fastjson.JSONArray;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectGradeInfoResult.java
 * @Description TODO
 * @createTime 2021年03月23日 10:45:00
 */
@Data
public class ProjectGradeInfoResult implements Serializable {

    /**
     * 项目id
     */
    private Long projectId;
    /**
     * 推广说明
     */
    private String notifyContent;
    /**
     * 项目有效期开始时间
     */
    private Date startTime;

    /**
     * 项目有效期结束时间
     */
    private Date endTime;

    private List<ProjectPushJsonDto> projectPushJsonList;
    /**
     * 员工业绩
     */
    private StaffGradeResult staffGrade;
    /**
     * 机构业绩
     */
    private SetupGradeResult setupGrade;


    /**
     * 员工业绩
     */
    @Data
    public static class StaffGradeResult implements Serializable {

        /**
         * 业绩说明
         */
        private String gradeExplain;
        /**
         * 总分
         */
        private Double allGrade;
        /**
         * 事件明细
         */
        private List<StaffEventGradeDto> details;

        public StaffGradeResult(){

        }

        public StaffGradeResult(StaffGradeDto staffGrade) {
            this.allGrade = staffGrade.getAllGrade();

            details = JSONArray.parseArray(staffGrade.getEventGrade(), StaffEventGradeDto.class);
            gradeExplain = staffGrade.getGradeExplain();

        }
    }

    /**
     * 机构业绩
     */
    @Data
    public static class SetupGradeResult implements Serializable {
        /**
         * 总分
         */
        private Double allGrade;
        /**
         * 所属机构下的本机构的排名
         */
        private Integer gradeRank;
        /**
         * 上级机构名称
         */
        private String fatherSetupName;

        private List<SetupGradeDetailDto> details;

        public SetupGradeResult(SetupGradeDto setupGrade, SetupDto fatherSetup) {
            allGrade = setupGrade.getAllGrade();
            gradeRank = setupGrade.getGradeRank();
            fatherSetupName = fatherSetup.getSetupName();
            details = JSONArray.parseArray(setupGrade.getGradeDetail(), SetupGradeDetailDto.class);


        }
    }

    public static ProjectGradeInfoResult buildProjectGradeInfoResult(ProjectDto project,
                                                                     StaffGradeDto staffGrade,
                                                                     SetupGradeDto setupGrade,
                                                                     SetupDto fatherSetup) {
        ProjectGradeInfoResult result = new ProjectGradeInfoResult();
        result.setProjectId(project.getId());
        result.setNotifyContent(project.getNotifyContent());
        result.setStartTime(project.getStartTime());
        result.setEndTime(project.getEndTime());
        result.setProjectPushJsonList(project.getProjectPushJsonDtos());

        result.staffGrade = new StaffGradeResult(staffGrade);

        result.setupGrade = new SetupGradeResult(setupGrade, fatherSetup);
        return result;
    }
}
