package cn.com.duiba.duiba.qutui.center.api.dto.task;

import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName StaffEventGradeDto.java
 * @Description TODO
 * @createTime 2021年03月23日 13:32:00
 */
@Data
public class EventGradeDto implements Serializable {

    /**
     * 事件显示名称
     */
    private String eventTxt;
    /**
     * 事件id
     */
    private Long eventId;
    /**
     * 事件总分
     */
    private Double eventGrade;

    /**
     * 是否统计参与人数
     */
    private Boolean joinPeopleNum = false;
    private String joinPeopleNumText;
    private Integer joinPeopleNumCount;
    /**
     * 是否统计参与次数
     */
    private Boolean joinNum = false;
    private String joinNumText;
    private Integer joinNumCount;
    /**
     * 是否统计完成人数
     */
    private Boolean finishJoinPeopleNum = false;
    private String finishJoinPeopleNumText;
    private Integer finishJoinPeopleNumCount;
    /**
     * 是否统计完成次数
     */
    private Boolean finishJoinNum = false;
    private String finishJoinNumText;
    private Integer finishJoinNumCount;

    /**
     * 是否统计自然流量
     */
    private Boolean isStatistical;
    private String statisticalText;
    private Integer statisticalCount;


    public void mergeEventGrade(EventGradeDto staffEventGradeDto){
        if (staffEventGradeDto!=null){
            eventGrade = staffEventGradeDto.getEventGrade();
            joinPeopleNumCount = staffEventGradeDto.getJoinPeopleNumCount();
            joinNumCount = staffEventGradeDto.getJoinNumCount();
            finishJoinPeopleNumCount = staffEventGradeDto.getFinishJoinPeopleNumCount();
            finishJoinNumCount = staffEventGradeDto.getFinishJoinNumCount();
            statisticalCount = staffEventGradeDto.getStatisticalCount();
        }else {
            eventGrade = 0D;
            joinPeopleNumCount = 0;
            joinNumCount = 0;
            finishJoinPeopleNumCount = 0;
            finishJoinNumCount = 0;
            statisticalCount = 0;
        }

    }


}
