package cn.com.duiba.duiba.qutui.center.api.remoteservice.setup.enums;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName SetupLevelEnum.java
 * @Description 机构等级枚举类
 * @createTime 2021年03月17日 10:27:00
 */
public enum SetupLevelEnum {

    ZERO(0, "母公司"),
    ONE(1, "一级"),
    TWO(2, "二级"),
    THREE(3, "三级"),
    FOUR(4, "四级"),
    FIVE(5, "五级")
    ;
    /**
     * 机构等级
     */
    private Integer level;
    /**
     * 描述
     */
    private String str;

    SetupLevelEnum(Integer level, String str) {
        this.level = level;
        this.str = str;
    }

    public static SetupLevelEnum getSetupLevelEnum(Integer level) {
        for (SetupLevelEnum value : SetupLevelEnum.values()) {
            if (value.level.compareTo(level) == 0) {
                return value;
            }
        }
        return null;
    }


    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getStr() {
        return str;
    }

    public void setStr(String str) {
        this.str = str;
    }
}
