package cn.com.duiba.duiba.qutui.center.api.enums;


import org.apache.commons.lang.StringUtils;
import org.checkerframework.checker.units.qual.C;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaotian on 2021/03/16.
 */
public enum ContentTypeEnum {

    /**
     * 内容类型
     */
    ARTICLE("article", "文章"),
    ACTIVITY("activity", "活动"),
    CARD_PRODUCT("card_product","名片产品"),
    CARD_ACTIVITY("card_activity","名片活动"),
    CARD_INFO("card_info","企业资讯"),
    TASK("task", "任务"),
    CARD("card","名片")
    ;

    private String code;
    private String desc;

    ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ContentTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ContentTypeEnum type : values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals(type, ARTICLE.code) ||
                StringUtils.equals(type, ACTIVITY.code) ||
                StringUtils.equals(type, CARD_ACTIVITY.code) ||
                StringUtils.equals(type, CARD_INFO.code) ||
                StringUtils.equals(type, CARD_PRODUCT.code) ;
    }

    public static boolean isTask(String type) {
        return StringUtils.equals(type, TASK.code);
    }



}
