package cn.com.duiba.duiba.qutui.center.api.result.task;

import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectPushJsonDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.SetupGradeDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectGradeInfoResult.java
 * @Description TODO
 * @createTime 2021年03月23日 10:45:00
 */
@Data
public class ProjectGradeInfoResult implements Serializable {

    /**
     * 项目id
     */
    private Long projectId;
    /**
     * 推广说明
     */
    private String notifyContent;
    /**
     * 项目有效期开始时间
     */
    private Date startTime;

    /**
     * 项目有效期结束时间
     */
    private Date endTime;

    /**
     * 上级机构名称
     */
    private String fatherSetupName;

    private List<ProjectPushJsonDto> projectPushJsonList;
    /**
     * 员工业绩
     */
    private StaffGradeResult staffGrade;
    /**
     * 机构业绩
     */
    private SetupGradeDto setupGrade;

    public static ProjectGradeInfoResult buildProjectGradeInfoResult(ProjectDto project, SetupDto fatherSetup,
                                                                     StaffGradeResult staffGradeResult,
                                                                     SetupGradeDto setupGrade) {
        ProjectGradeInfoResult result = new ProjectGradeInfoResult();
        result.setProjectId(project.getId());
        result.setNotifyContent(project.getNotifyContent());
        result.setStartTime(project.getStartTime());
        result.setEndTime(project.getEndTime());
        result.setProjectPushJsonList(project.getProjectPushJsonDtos());
        result.setFatherSetupName(fatherSetup.getSetupName());

        result.staffGrade = staffGradeResult;

        result.setupGrade = setupGrade;
        return result;
    }
}
