package cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.customer;

import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.BaseMessageDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * Created by dugq on 2020-02-06.
 * 公众号的视频消息体
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerVideoDto extends BaseMessageDto {
    private static final long serialVersionUID = -3660444212557224177L;

    /**
     * 标题
     */
    @NotBlank(message = "视频消息标题为空")
    private String title;
    /**
     * 描述
     */
    @NotBlank(message = "描述不能为空")
    private String desc;
    /**
     * 微信视频地址
     */
    private String mediaId;

    /**
     * 封面图ID
     */
    private String thumbMediaId;
}
