package cn.com.duiba.duiba.qutui.center.api.remoteservice.setup;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupDto;
import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupStaffImportDto;
import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupUserDto;
import cn.com.duiba.duiba.qutui.center.api.result.PageResult;
import cn.com.duiba.duiba.qutui.center.api.result.QuTuiResult;
import cn.com.duiba.duiba.qutui.center.api.result.setup.AddChildSetupResult;
import cn.com.duiba.duiba.qutui.center.api.result.setup.RegisterSetupResult;
import cn.com.duiba.duiba.qutui.center.api.result.setup.SetupInfo;

import java.util.List;

/**
 * 机构表 RemoteService
 *
 * @author xiaotian
 * 2021-3-16 15:34:08
 */
@AdvancedFeignClient
public interface RemoteSetupService {


    public SetupDto getById(Long id);

    /**
     * 获取指定机构下的指定等级
     *
     * @param fatherSetupId
     * @param level
     * @return
     */
    List<SetupDto> getSetup(Long fatherSetupId, Integer level) throws BizException;

    PageResult<SetupDto> getSetups(String setupName, Integer level, Integer status, Integer pageNum, Integer pageSize);

    PageResult<SetupDto> getChildSetup(String setupName,Long setupId, Integer level, Integer pageNum, Integer pageSize);

    /**
     * 注册机构
     *
     * @param setups
     * @param setupUser
     * @return
     */
    RegisterSetupResult registerSetup(List<SetupDto> setups, SetupUserDto setupUser) throws BizException;

    /**
     * 修改机构名称
     *
     * @param setupId   机构id
     * @param setupName 机构名称
     * @return
     */
    boolean update(Long setupId, String setupName) throws BizException;

    /**
     * 机构详细信息
     *
     * @param setupId
     * @return
     */
    SetupInfo getSetupInfo(Long setupId) throws BizException;

    /**
     * 导入子机构
     *
     * @param setupId
     * @param createId
     * @param setupDtos
     * @return
     */
    AddChildSetupResult addChildSetup(Long setupId, Long createId, List<SetupDto> setupDtos) throws BizException;

    /**
     * 导入员工
     *
     * @param setupId
     * @param createId
     * @param staffs
     * @return
     */
    boolean addStaffs(Long setupId, Long createId, List<SetupStaffImportDto> staffs) throws BizException;


}
