/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.qutui.center.api.util;

import cn.com.duiba.duiba.qutui.center.api.enums.crypto.IdConvertBase64Enum;
import cn.com.duiba.duiba.qutui.center.api.util.IdEncodeByBase64;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdMakerUtil {
    private static final Logger log = LoggerFactory.getLogger(IdMakerUtil.class);
    private static final LocalDate cardOverTime = LocalDate.of(2021, 2, 7);
    private static final String OPEN_PREFIX = "qt-";

    private IdMakerUtil() {
    }

    public static Long decodingOpen(String openId) {
        if (Objects.isNull(openId)) {
            return null;
        }
        if (openId.startsWith(OPEN_PREFIX)) {
            return IdEncodeByBase64.decodingId(openId.replace(OPEN_PREFIX, ""));
        }
        return null;
    }

    public static String encodingIdByBase64(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, IdConvertBase64Enum.DEF);
    }

    public static String encodingIdByBase64(Long id, IdConvertBase64Enum base64Enum) {
        if (Objects.isNull(id) || base64Enum == null) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, base64Enum);
    }

    public static Long decodingIdByBase64(String encode) {
        return IdEncodeByBase64.decodingId(encode);
    }

    public static Long decodingIdByBase64ForScid(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        return IdMakerUtil.decodingIdByBase64(value);
    }

    public static Long decodingId(String encode) {
        return IdMakerUtil.decodingIdByBase64(encode);
    }

    public static Long compatibleDecodingId(String encode, Long compatibleId) {
        Long id = IdMakerUtil.decodingId(encode);
        if (Objects.isNull(id) && NumberUtils.isNumber((String)encode)) {
            id = Long.valueOf(encode);
            if (Objects.nonNull(compatibleId) && id > compatibleId) {
                return null;
            }
        }
        return id;
    }

    public static Long compatibleDecodingIdByBase64(String encode, Long compatibleId) {
        if (NumberUtils.isNumber((String)encode)) {
            Long id = Long.valueOf(encode);
            if (id < compatibleId || compatibleId == -1L) {
                return id;
            }
            return null;
        }
        return IdMakerUtil.decodingId(encode);
    }
}

