package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.task.EventGradeDto;
import cn.com.duiba.duiba.qutui.center.api.result.PageResult;
import cn.com.duiba.duiba.qutui.center.api.result.task.ProjectGradeInfoResult;
import cn.com.duiba.duiba.qutui.center.api.result.task.ProjectSetupSortResult;
import cn.com.duiba.duiba.qutui.center.api.result.task.ProjectStaffSortResult;
import cn.com.duiba.duiba.qutui.center.api.result.task.SortResult;
import cn.com.duiba.duiba.qutui.center.api.result.task.StaffProjectResult;

import java.util.List;

/**
 * ;
 *
 * @author linzhou
 * @version 1.0.0
 * @ClassName RemoteProjectWebService.java
 * @Description TODO
 * @createTime 2021年03月22日 21:15:00
 */
@AdvancedFeignClient
public interface RemoteProjectWebService {

    /**
     * 项目列表
     *
     * @param staffId
     * @param projectName
     * @param isPushing
     * @param pageNum
     * @param pageSize
     * @return
     * @throws BizException
     */
    PageResult<StaffProjectResult> getStaffProjectList(Long staffId, String projectName,
                                                       Boolean isPushing,
                                                       Integer pageNum, Integer pageSize) throws BizException;

    /**
     * 项目信息
     *
     * @param projectId
     * @param staffId
     * @return
     * @throws BizException
     */
    ProjectGradeInfoResult getProjectGradeInfo(Long projectId, Long staffId) throws BizException;

    /**
     * 机构项目业绩
     *
     * @param projectId
     * @param setupId
     * @return
     */
    List<EventGradeDto> getSetupEventGradeList(Long projectId, Long setupId);

    /**
     * 指定等级的自己上级机构在其所属机构的排名
     *
     * @param projectId
     * @param setupId
     * @param level
     * @return
     */
    SortResult<ProjectSetupSortResult> getSetupGradeList(Long projectId, Long setupId, Integer level);


    /**
     * 当前机构再其所属机构的排名
     *
     * @param setupId
     * @param projectId
     * @return
     */
    SortResult<ProjectSetupSortResult> getSelfSetupGradeList(Long setupId, Long projectId);

    /**
     * 获取指定机构的子机构的排名
     *
     * @param fatherSetupId
     * @param projectId
     * @return
     */
    List<ProjectSetupSortResult> getChildSetupGradeList(Long fatherSetupId, Long projectId);


    /**
     * 获取机构的员工排名
     *
     * @param setupId
     * @param projectId
     * @param staffId
     * @param current
     * @param pageSize
     * @return
     */
    SortResult<ProjectStaffSortResult> getSetupStaffGradeSort(Long setupId, Long projectId, Long staffId, Integer current, Integer pageSize);
}
