package cn.com.duiba.duiba.qutui.center.api.param.mpAccount.audit;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangxukai
 * @description UGC安全检查
 * @date ：Created in 2021/3/24
 */
@Data
public class ComponentAuditUGCParam implements Serializable {

    /**
     * UGC场景 0,不涉及用户生成内容, 1.用户资料,2.图片,3.视频,4.文本,5其他, 可多选,当scene填0时无需填写下列字段
     */
    private List<Integer> scene;
    /**
     * 当scene选其他时的说明,不超时256字
     */
    private String otherSceneDesc;
    /**
     * 内容安全机制 1.使用平台建议的内容安全API,2.使用其他的内容审核产品,3.通过人工审核把关,4.未做内容审核把关
     */
    private List<Integer> method;
    /**
     * 是否有审核团队, 0.无,1.有,默认0
     */
    private Integer hasAuditTeam;
    /**
     * 说明当前对UGC内容的审核机制,不超过256字
     */
    private String auditDesc;

}
