package cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.wrapper;

import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.MessageUserDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.template.TemplateMessageDto;
import cn.com.duiba.duiba.qutui.center.api.enums.DegradedTypeEnum;
import cn.com.duiba.duiba.qutui.center.api.enums.MessageTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Created by dugq on 2020-02-10.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
public class SingleWxMessageWrapperDto extends WxMessageWrapperDto {
    private static final long serialVersionUID = -3017438467734704621L;

    private MessageUserDto user;

    /**
     * 如何降级消息的oaID和推送事件都和推送事件不变，仅仅是推送模版消息时，可以直接追加
     * 符合大部分情况，提供简单追加降级方案的方法
     * 可以换人推送
     * @param degradedMessageDto 降级模版消息
     */
    public void adddegradedTemplateMessageDto(TemplateMessageDto degradedMessageDto, MessageUserDto user){
        SingleWxMessageWrapperDto degradedMessageWrapperDto = new SingleWxMessageWrapperDto();
        degradedMessageWrapperDto.setUser(user);
        degradedMessageWrapperDto.setMessageType(MessageTypeEnum.TEMPLATE.getCode());
        degradedMessageWrapperDto.setDegradedType(DegradedTypeEnum.DISCARD.getCode());
        super.setDegradedType(DegradedTypeEnum.OTHER_MESSAGE.getCode());
        degradedMessageWrapperDto.setMessageDto(degradedMessageDto);
        this.degradedMessageWrapperDto = degradedMessageWrapperDto;
    }
}
