package cn.com.duiba.duiba.qutui.center.api.result.task;

import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.SetupGradeDto;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectSetupSortResult.java
 * @Description TODO
 * @createTime 2021年03月24日 20:51:00
 */
@Data
public class ProjectSetupSortResult implements Serializable {

    /**
     * 机构名称
     */
    private String setupName;
    /**
     * 机构id
     */
    private Long setupId;
    /**
     * 机构等级
     */
    private Integer setupLevel;
    /**
     * 排名
     */
    private Integer gradeRank;
    /**
     * 当前机构
     */
    private Boolean self;

    /**
     * 总分
     */
    private Double allGrade;


    public ProjectSetupSortResult(SetupDto setup, SetupGradeDto setupGrade){
        setupName = setup.getSetupName();
        setupId = setup.getId();
        setupLevel = setup.getSetupLevel();
        gradeRank = setupGrade.getGradeRank();
        allGrade = setupGrade.getAllGrade();
        self = false;
    }

}
