package cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.result;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Created by dugq on 2020-03-11.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PerpetualMaterialResult extends WechatResultBean {
    private static final long serialVersionUID = -3054011539614926440L;

    /**
     * 媒体ID
     */
    private String mediaId;
    /**
     * 图片地址
     */
    private String url;

    /**
     * 公众号ID
     */
    private Long oaId;

    public static PerpetualMaterialResult buildResponseError(){
        PerpetualMaterialResult wechatResultBean = new PerpetualMaterialResult();
        wechatResultBean.setErrCode(-7L);
        wechatResultBean.setErrMsg("请求结果并非期望值");
        return wechatResultBean;
    }


    public static PerpetualMaterialResult paramError(){
        PerpetualMaterialResult wechatResultBean = new PerpetualMaterialResult();
        wechatResultBean.setErrCode(-5L);
        wechatResultBean.setErrMsg("参数错误");
        return wechatResultBean;
    }

    public static PerpetualMaterialResult httpError(){
        PerpetualMaterialResult wechatResultBean = new PerpetualMaterialResult();
        wechatResultBean.setErrCode(-6L);
        wechatResultBean.setErrMsg("httpclient 发送请求时错误");
        return wechatResultBean;
    }
}
