package cn.com.duiba.duiba.qutui.center.api.enums;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/7/12 12:56 PM
 */
public enum PushMessageTypeEnum {

    KEFU_TEXT(1, "客服文本消息"),
    KEFU_PIC_TEXT(2, "客服图文消息"),
    TEMPLATE(3, "模板消息"),
    KEFU_MINI(4, "公众号客服小程序卡片"),
    KEFU_PIC(5, "公众号图片消息"),
    TEMPLATE_MP(10, "小程序模板消息"),
    SUBSCRIBE_MP(11, "小程序订阅消息"),
    KEFU_PIC_MP(12, "小程序客服图片消息"),
    KEFU_PIC_TEXT_MP(13, "小程序客服图文消息"),
    ;

    private Integer type;

    private String desc;

    PushMessageTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

   public static PushMessageTypeEnum getByMessageType(Integer type,Integer target){
        if(Objects.isNull(target) || Objects.isNull(type)){
            return null;
        }
        if(Objects.equals(target, OaTargetEnum.OA.getCode())){
            switch (type){
                case 1:
                    return KEFU_TEXT;
                case 2:
                    return KEFU_PIC;
                case 3:
                    return null;
                case 4:
                    return  null;
                case 5:
                    return null;
                case 6:
                    return KEFU_PIC_TEXT;
                case 7:
                    return null;
                case 8:
                    return KEFU_MINI;
                case 9:
                    return null;
                case 10:
                    return TEMPLATE;
                case 11:
                    return null;
                    default:
                        return null;
            }
        }else if(Objects.equals(target, OaTargetEnum.MP.getCode())){
            switch (type){
                case 1:
                    return KEFU_TEXT;
                case 2:
                    return KEFU_PIC_MP;
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                    return null;
                case 10:
                    return TEMPLATE_MP;
                case 11:
                    return SUBSCRIBE_MP;
                case 12:
                    return KEFU_PIC_TEXT_MP;
                default:
                    return null;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
