package cn.com.duiba.duiba.qutui.center.api.util;

import cn.com.duiba.duiba.qutui.center.api.enums.crypto.IdConvertBase64Enum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

import java.time.LocalDate;
import java.util.Objects;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2021/3/18 14:48
 * @Description:
 */
@Slf4j
public class IdMakerUtil {

    private static final LocalDate cardOverTime = LocalDate.of(2021,2,7);

    private IdMakerUtil() {
    }

    /**
     * 用base64 的方式编码加密ID
     * 详细编码请看 IdEncodeByBase64.class
     * @param id
     * @return
     */
    public static String encodingIdByBase64(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, IdConvertBase64Enum.DEF);
    }

    /**
     * 用base64 的方式编码加密ID
     * 详细编码请看 IdEncodeByBase64.class
     * @param id
     * @return
     */
    public static String encodingIdByBase64(Long id, IdConvertBase64Enum base64Enum) {
        if (Objects.isNull(id) || base64Enum == null) {
            return null;
        }
        return IdEncodeByBase64.encodingId(id, base64Enum);
    }

    /**
     * 解密base64
     * @param encode
     * @return 失败返回null
     */
    public static Long decodingIdByBase64(String encode) {
        return IdEncodeByBase64.decodingId(encode);
    }


    /**
     * 解密base64（为scid加密定制）
     * @param value
     * @return 失败返回null
     */
    public static Long decodingIdByBase64ForScid(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return decodingIdByBase64(value);
    }


    /**
     * 混合式解密，给个字符串，尝试多种方法解密
     * @param encode
     * @return  失败返回null
     */
    public static Long decodingId(String encode){
        return decodingIdByBase64(encode);
    }

    public static Long compatibleDecodingId(String encode,Long compatibleId){
        Long id = decodingId(encode);
        if(Objects.isNull(id) && NumberUtils.isNumber(encode)){
            id = Long.valueOf(encode);
            if(Objects.nonNull(compatibleId) && id > compatibleId){
                return null;
            }
        }
        return id;
    }

    /**
     * 兼容式解密。只针对于base64加密。不能针对纯数字加密，因为数字会出现无法判断它是加密的还是没有加密的
     * 部分接口，比如分享，ID必须兼容以前的版本。
     * 如果encode 是顺数字，并且小于 compatibleId ，则直接返回 encode 本身
     * @param encode
     * @param compatibleId 兼容的最大ID。 -1 无限兼容
     * @return
     */
    public static Long compatibleDecodingIdByBase64(String encode, Long compatibleId) {
        if (NumberUtils.isNumber(encode)) {
            Long id = Long.valueOf(encode);
            if (id < compatibleId || compatibleId == -1L) {
                return id;
            } else {
                return null;
            }
        } else {
            return decodingId(encode);
        }
    }

}