package cn.com.duiba.duiba.qutui.center.api.bean;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.enums.ErrorCode;

/**
 * Created by dugq on 2020-02-04.
 */
public class WechatServiceException extends BizException {
    private static final long serialVersionUID = -8605238686296377226L;
    private ErrorCode errorCode;

    public WechatServiceException(String msg) {
        super(msg);
    }

    /**
     * 构造一个业务异常，通常而言这个异常的message是应该直接回显给用户的，比如"用户已存在".
     *
     * @param errorCode 默认异常消息，表示具体的错误信息，比如『用户不存在』(后期国际化以后，这个可以用于表示默认异常消息，服务端优先根据key去找到对应语言的错误消息并替换message【服务端从RpcContext中获得当前语言环境】，找不到则不替换)
     */
    public WechatServiceException(ErrorCode errorCode) {
        super(errorCode.getDesc());
        this.withCode(errorCode.getCode());
        this.errorCode = errorCode;
    }

    public WechatServiceException(ErrorCode errorCode, String desc) {
        super(desc);
        this.withCode(errorCode.getCode());
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }
}
