package cn.com.duiba.duiba.qutui.center.api.dto.wxmessage;

import cn.com.duiba.duiba.qutui.center.api.enums.WxErrorCodeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.Objects;

/**
 * post接口的基础响应
 * @author lizhi
 * @date 2020/9/29 11:38 AM
 */
@Data
@Slf4j
public class WxBaseResponse implements Serializable {

    private static final long serialVersionUID = -5825595760787692887L;

    /**
     * 响应码
     */
    @JSONField(name = "errcode")
    private Long errCode;

    /**
     * 错误描述
     */
    @JSONField(name = "errmsg")
    private String errMsg;

    public Boolean success(){
        return Objects.equals(0L, this.getErrCode()) || Objects.isNull(this.getErrCode());
    }

    public static WxBaseResponse paramNull(){
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-2L);
        wechatResultBean.setErrMsg("参数为空");
        return wechatResultBean;
    }

    public static WxBaseResponse requestNoResponse(){
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-4L);
        wechatResultBean.setErrMsg("请求没有回复");
        return wechatResultBean;
    }

    public static WxBaseResponse paramError(){
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-5L);
        wechatResultBean.setErrMsg("参数错误");
        return wechatResultBean;
    }

    /**
     * 自定义错误信息的参数错误。
     * @param desc 错误描述
     * @param responseClass 返回值类型
     * @param <T>  <span style="color:red">必须拥有无参构造器</span>
     * @return T 类型的对象
     */
    public static <T extends WxBaseResponse> T customParamError(String desc, Class<T> responseClass){
        try {
            T result = responseClass.newInstance();
            result.setErrCode(WxErrorCodeEnum.E_5.getCode());
            result.setErrMsg(desc);
            return result;
        } catch (InstantiationException | IllegalAccessException e) {
           log.warn("create customer param error response error .down gradle user copy,but create 2 object.",e);
            WxBaseResponse wxBaseResponse = paramError();
            wxBaseResponse.setErrMsg(desc);
           return BeanUtils.copy(wxBaseResponse,responseClass);
        }
    }

    public static WxBaseResponse requestError(){
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-7L);
        wechatResultBean.setErrMsg("请求时发生错误");
        return wechatResultBean;
    }

    public static WxBaseResponse httpError(){
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-8L);
        wechatResultBean.setErrMsg("httpclient发生错误");
        return wechatResultBean;
    }

    public static WxBaseResponse responseError(){
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-9L);
        wechatResultBean.setErrMsg("请求返回值读取错误");
        return wechatResultBean;
    }

    public static WxBaseResponse systemError(){
        WxBaseResponse wechatResultBean = new WxBaseResponse();
        wechatResultBean.setErrCode(-9999L);
        wechatResultBean.setErrMsg("未知错误");
        return wechatResultBean;
    }

}
