package cn.com.duiba.duiba.qutui.center.api.enums;

import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 微信错误码
 * @author xiaotian
 * @date 2020-01-15
 */
@Slf4j
public enum WxErrorCodeEnum {
    E_10000(-10000L,"错误码暂时找不到对应"),
    //请求发生未知错误，可能已经成功，不可盲目重试
    E_8(-8L,"请求发送异常"),
    //确认请求未发出。可选择重试
    E_7(-7L,"httpclient 发送请求时错误"),
    //微信有些功能是下限不可用的，活着API中功能未开放
    E_6(-6L,"功能下线"),
    E_5(-5L,"参数错误"),
    //socket超时，但请求已经发出
    E_4(-4L,"请求没有回复"),
    //特殊情况
    E_3(-3L,"配置不发送消息"),
    E_2(-2L,"参数为空"),
    E_1(-1L,"系统繁忙，请开发者重试"),
    E0(0L,"请求成功"),
    E40001(40001L,"获取 access_token 时 AppSecret 错误，或者 access_token 无效。请开发者认真比对 AppSecret 的正确性，或查看是否正在为恰当的公众号调用接口"),
    E40002(40002L,"不合法的凭证类型"),
    E40003(40003L,"不合法的 OpenID ，请开发者确认 OpenID （该用户）是否已关注公众号，或是否是其他公众号的 OpenID"),
    E40004(40004L,"不合法的媒体文件类型"),
    E40005(40005L,"不合法的文件类型"),
    E40006(40006L,"不合法的文件大小"),
    E40007(40007L,"不合法的媒体文件 id"),
    E40008(40008L,"不合法的消息类型"),
    E40009(40009L,"不合法的图片文件大小"),
    E40010(40010L,"不合法的语音文件大小"),
    E40011(40011L,"不合法的视频文件大小"),
    E40012(40012L,"不合法的缩略图文件大小"),
    E40013(40013L,"不合法的 AppID ，请开发者检查 AppID 的正确性，避免异常字符，注意大小写"),
    E40014(40014L,"不合法的 access_token ，请开发者认真比对 access_token 的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口"),
    E40015(40015L,"不合法的菜单类型"),
    E40016(40016L,"不合法的按钮个数"),
    E40017(40017L,"不合法的按钮类型"),
    E40018(40018L,"不合法的按钮名字长度"),
    E40019(40019L,"不合法的按钮 KEY 长度"),
    E40020(40020L,"不合法的按钮 URL 长度"),
    E40021(40021L,"不合法的菜单版本号"),
    E40022(40022L,"不合法的子菜单级数"),
    E40023(40023L,"不合法的子菜单按钮个数"),
    E40024(40024L,"不合法的子菜单按钮类型"),
    E40025(40025L,"不合法的子菜单按钮名字长度"),
    E40026(40026L,"不合法的子菜单按钮 KEY 长度"),
    E40027(40027L,"不合法的子菜单按钮 URL 长度"),
    E40028(40028L,"不合法的自定义菜单使用用户"),
    E40029(40029L,"无效的 oauth_code"),
    E40030(40030L,"不合法的 refresh_token"),
    E40031(40031L,"不合法的 openid 列表"),
    E40032(40032L,"不合法的 openid 列表长度"),
    E40033(40033L,"不合法的请求字符，不能包含 \\uxxxx 格式的字符"),
    E40035(40035L,"不合法的参数"),
    E40038(40038L,"不合法的请求格式"),
    E40039(40039L,"不合法的 URL 长度"),
    E40048(40048L,"无效的url"),
    E40050(40050L,"不合法的分组 id"),
    E40051(40051L,"分组名字不合法"),
    E40054(40054L,"invalid sub button url domain"),
    E40055(40055L,"invalid button url domain"),
    E40060(40060L,"删除单篇图文时，指定的 article_idx 不合法"),
    E40066(40066L,"invalid url"),
    E40097(40097L,"参数错误"),
    E40117(40117L,"分组名字不合法"),
    E40118(40118L,"media_id 大小不合法"),
    E40119(40119L,"button 类型错误"),
    E40120(40120L,"子 button 类型错误"),
    E40121(40121L,"不合法的 media_id 类型"),
    E40125(40125L,"无效的appsecret"),
    E40132(40132L,"微信号不合法"),
    E40137(40137L,"不支持的图片格式"),
    E40155(40155L,"请勿添加其他公众号的主页链接"),
    E40163(40163L,"oauth_code已使用"),
    E41001(41001L,"缺少 access_token 参数"),
    E41002(41002L,"缺少 appid 参数"),
    E41003(41003L,"缺少 refresh_token 参数"),
    E41004(41004L,"缺少 secret 参数"),
    E41005(41005L,"缺少多媒体文件数据"),
    E41006(41006L,"缺少 media_id 参数"),
    E41007(41007L,"缺少子菜单数据"),
    E41008(41008L,"缺少 oauth code"),
    E41009(41009L,"缺少 openid"),
    E41010(41010L,"missing url"),
    E41030(41030L,"所传page页面不存在，或者小程序没有发布"),
    E42001(42001L,"access_token 超时，请检查 access_token 的有效期，请参考基础支持 - 获取 access_token 中，对 access_token 的详细机制说明"),
    E42002(42002L,"refresh_token 超时"),
    E42003(42003L,"oauth_code 超时"),
    E42007(42007L,"用户修改微信密码， accesstoken 和 refreshtoken 失效，需要重新授权"),
    E43001(43001L,"需要 GET 请求"),
    E43002(43002L,"需要 POST 请求"),
    E43003(43003L,"需要 HTTPS 请求"),
    E43004(43004L,"需要接收者关注"),
    E43005(43005L,"需要好友关系"),
    E43104(43104L, "appid与openid不匹配"),
    E40036(40036L,"invalid template_id size"),
    E40037(40037L,"invalid template_id"),
    E43019(43019L,"需要将接收者从黑名单中移除"),
    E43101(43101L,"用户拒绝授权"),
    E44001(44001L,"多媒体文件为空"),
    E44002(44002L,"POST 的数据包为空"),
    E44003(44003L,"图文消息内容为空"),
    E44004(44004L,"文本消息内容为空"),
    E44005(44005L,"empty list size"),
    E45001(45001L,"多媒体文件大小超过限制"),
    E45002(45002L,"消息内容超过限制"),
    E45003(45003L,"标题字段超过限制"),
    E45004(45004L,"描述字段超过限制"),
    E45005(45005L,"链接字段超过限制"),
    E45006(45006L,"图片链接字段超过限制"),
    E45007(45007L,"语音播放时间超过限制"),
    E45008(45008L,"图文消息超过限制"),
    E45009(45009L,"接口调用超过限制"),
    E45010(45010L,"创建菜单个数超过限制"),
    E45011(45011L,"API 调用太频繁，请稍候再试"),
    E45012(45012L,"template size out of limit"),
    E45015(45015L,"回复时间超过限制"),
    E45016(45016L,"系统分组，不允许修改"),
    E45017(45017L,"分组名字过长"),
    E45018(45018L,"分组数量超过上限"),
    E45047(45047L,"客服接口下行条数超过上限"),
    E45056(45056L,"创建的标签数过多，请注意不能超过100个"),
    E45057(45057L,"该标签下粉丝数超过10w，不允许直接删除"),
    E45058(45058L,"不能修改0/1/2这三个系统默认保留的标签"),
    E45059(45059L,"有粉丝身上的标签数已经超过限制，即超过20个"),
    E45064(45064L,"创建菜单包含未关联的小程序"),
    E45065(45065L,"相同 clientmsgid 已存在群发记录，返回数据中带有已存在的群发任务的 msgid"),
    E45066(45066L,"相同 clientmsgid 重试速度过快，请间隔1分钟重试"),
    E45067(45067L,"clientmsgid 长度超过限制"),
    E45157(45157L,"标签名非法，请注意不能和其他标签重名"),
    E45158(45158L,"标签名长度超过30个字节"),
    E45159(45159L,"非法的tag_id"),
    E46001(46001L,"不存在媒体数据"),
    E46002(46002L,"不存在的菜单版本"),
    E46003(46003L,"不存在的菜单数据"),
    E46004(46004L,"不存在的用户"),
    E47001(47001L,"解析 JSON/XML 内容错误"),
    E48001(48001L,"api 功能未授权，请确认公众号已获得该接口，可以在公众平台官网 - 开发者中心页中查看接口权限"),
    E48002(48002L,"粉丝拒收消息（粉丝在公众号选项中，关闭了 “ 接收消息 ” ）"),
    E48004(48004L,"api 接口被封禁，请登录 mp.weixin.qq.com 查看详情"),
    E48005(48005L,"api 禁止删除被自动回复和自定义菜单引用的素材"),
    E48006(48006L,"api 禁止清零调用次数，因为清零次数达到上限"),
    E48008(48008L,"没有该类型消息的发送权限"),
    E49003(49003L,"传入的openid不属于此AppID"),
    E50001(50001L,"用户未授权该 api"),
    E50002(50002L,"用户受限，可能是违规后接口被封禁"),
    E50005(50005L,"用户未关注公众号"),
    E53200(53200L,"本月功能介绍修改次数已用完"),
    E53201(53201L,"功能介绍内容命中黑名单关键字"),
    E53202(53202L,"本月头像修改次数已用完"),
    E53300(53300L,"超出每月次数限制"),
    E53301(53301L,"超出可配置类目总数限制"),
    E53302(53302L,"当前账号主体类型不允许设置此种类目"),
    E53303(53303L,"提交的参数不合法"),
    E53304(53304L,"与已有类目重复"),
    E53305(53305L,"包含未通过 ICP 校验的类目"),
    E53306(53306L,"修改类目只允许修改类目资质，不允许修改类目 ID"),
    E53307(53307L,"只有审核失败的类目允许修改"),
    E53308(53308L,"审核中的类目不允许删除"),
    E61007(61007L,"小程序尚未将对应的权限集授权给第三方平台"),
    E61010(61010L, "openid超时"),
    E61451(61451L,"参数错误 (invalid parameter)"),
    E61452(61452L,"无效客服账号 (invalid kf_account)"),
    E61453(61453L,"客服帐号已存在 (kf_account exsited)"),
    E61454(61454L,"客服帐号名长度超过限制 ( 仅允许 10 个英文字符，不包括 @ 及 @ 后的公众号的微信号 )(invalid   kf_acount length)"),
    E61455(61455L,"客服帐号名包含非法字符 ( 仅允许英文 + 数字 )(illegal character in     kf_account)"),
    E61456(61456L,"客服帐号个数超过限制 (10 个客服账号 )(kf_account count exceeded)"),
    E61457(61457L,"无效头像文件类型 (invalid   file type)"),
    E61450(61450L,"系统错误 (system error)"),
    E61500(61500L,"日期格式错误"),
    E63001(63001L,"部分参数为空"),
    E63002(63002L,"无效的签名"),
    E65301(65301L,"不存在此 menuid 对应的个性化菜单"),
    E65302(65302L,"没有相应的用户"),
    E65303(65303L,"没有默认菜单，不能创建个性化菜单"),
    E65304(65304L,"MatchRule 信息为空"),
    E65305(65305L,"个性化菜单数量受限"),
    E65306(65306L,"不支持个性化菜单的帐号"),
    E65307(65307L,"个性化菜单信息为空"),
    E65308(65308L,"包含没有响应类型的 button"),
    E65309(65309L,"个性化菜单开关处于关闭状态"),
    E65310(65310L,"填写了省份或城市信息，国家信息不能为空"),
    E65311(65311L,"填写了城市信息，省份信息不能为空"),
    E65312(65312L,"不合法的国家信息"),
    E65313(65313L,"不合法的省份信息"),
    E65314(65314L,"不合法的城市信息"),
    E65316(65316L,"该公众号的菜单设置了过多的域名外跳（最多跳转到 3 个域名的链接）"),
    E65317(65317L,"不合法的 URL"),
    E85006(85006L,"标签格式错误"),
    E85007(85007L,"页面路径错误"),
    E85008(85008L,"当前小程序没有已经审核通过的类目，请添加类目成功后重试"),
    E85009(85009L,"已经有正在审核的版本"),
    E85010(85010L,"item_list 有项目为空"),
    E85011(85011L,"标题填写错误"),
    E85012(85012L,"无效的审核 id"),
    E85013(85013L,"无效的自定义配置"),
    E85014(85014L,"无效的模板编号"),
    E85015(85015L,"该账号不是小程序账号"),
    E85016(85016L,"域名数量超过限制 ，总数不能超过1000"),
    E85017(85017L,"没有新增域名，请确认小程序已经添加了域名或该域名是否没有在第三方平台添加"),
    E85018(85018L,"域名没有在第三方平台设置"),
    E85023(85023L,"审核列表填写的项目数不在 1-5 以内"),
    E85043(85043L,"模板错误"),
    E85044(85044L,"代码包超过大小限制"),
    E85045(85045L,"ext_json 有不存在的路径"),
    E85046(85046L,"tabBar 中缺少 path"),
    E85047(85047L,"pages 字段为空"),
    E85048(85048L,"ext_json 解析失败"),
    E85051(85051L,"version_desc或者preview_info超限"),
    E85064(85064L,"找不到草稿"),
    E85065(85065L,"模板库已满"),
    E85066(85066L,"非法的插件版本"),
    E85067(85067L,"找不到使用的插件"),
    E85077(85077L,"小程序类目信息失效（类目中含有官方下架的类目，请重新选择类目）"),
    E85082(85082L,"没有权限使用该插件"),
    E85085(85085L,"小程序提审数量已达本月上限，请点击查看《临时quota申请流程》"),
    E85086(85086L,"提交代码审核之前需提前上传代码"),
    E85087(85087L,"小程序已使用 api navigateToMiniProgram，请声明跳转 appid 列表后再次提交"),
    E85092(85092L,"preview_info格式错误"),
    E85093(85093L,"preview_info"),
    E85094(85094L,"需提供审核机制说明信息"),
    E86000(86000L,"不是由第三方代小程序进行调用"),
    E86001(86001L,"不存在第三方的已经提交的代码"),
    E86002(86002L,"小程序还未设置昵称、头像、简介。请先设置完后再重新提交"),
    E86007(86007L,"小程序禁止提交"),
    E86009(86009L,"服务商新增小程序代码提审能力被限制"),
    E86010(86010L,"服务商迭代小程序代码提审能力被限制"),
    E87006(87006L,"小游戏不能提交"),
    E87009(87009L,"无效的签名"),
    E87011(87011L,"现网已经在灰度发布，不能进行版本回退"),
    E87012(87012L,"该版本不能回退，可能的原因：1:无上一个线上版用于回退 2:此版本为已回退版本，不能回退 3:此版本为回退功能上线之前的版本，不能回退"),
    E87013(87013L,"撤回次数达到上限（每天5次，每个月 10 次）"),
    E89021(89021L,"业务域名需经过ICP备案"),
    E89401(80401L,"系统不稳定，请稍后再试，如多次失败请通过社区反馈"),
    E89402(80402L,"该审核单不在待审核队列，请检查是否已提交审核或已审完"),
    E89403(80403L,"本单属于平台不支持加急种类，请等待正常审核流程"),
    E89404(80404L,"本单已加速成功，请勿重复提交"),
    E89405(80405L,"本月加急额度不足，请提升提审质量以获取更多额度"),
    E85052(85052L,"app已发布"),
    E200011(200011L,"此账号已被封禁，无法操作"),
    E200012(200012L,"个人模版数已达上限，上限25个"),
    E200013(200013L,"此模版已被封禁，无法选用"),
    E200014(200014L,"模版 tid 参数错误"),
    E200016(200016L,"start 参数错误"),
    E200017(200017L,"limit 参数错误"),
    E200018(200018L,"类目 ids 缺失"),
    E200019(200019L,"类目 ids 不合法"),
    E200020(200020L,"关键词列表 kidList 参数错误"),
    E200021(200021L,"场景描述 sceneDesc 参数错误"),
    E200022(200022L,"订阅消息模版已添加"),
    E9001001(9001001L,"POST 数据参数不合法"),
    E9001002(9001002L,"远端服务不可用"),
    E9001003(9001003L,"Ticket 不合法"),
    E9001004(9001004L,"获取摇周边用户信息失败"),
    E9001005(9001005L,"获取商户信息失败"),
    E9001006(9001006L,"获取 OpenID 失败"),
    E9001007(9001007L,"上传文件缺失"),
    E9001008(9001008L,"上传素材的文件类型不合法"),
    E9001009(9001009L,"上传素材的文件尺寸不合法"),
    E9001010(9001010L,"上传失败"),
    E9001020(9001020L,"帐号不合法"),
    E9001021(9001021L,"已有设备激活率低于 50% ，不能新增设备"),
    E9001022(9001022L,"设备申请数不合法，必须为大于 0 的数字"),
    E9001023(9001023L,"已存在审核中的设备 ID 申请"),
    E9001024(9001024L,"一次查询设备 ID 数量不能超过 50"),
    E9001025(9001025L,"设备 ID 不合法"),
    E9001026(9001026L,"页面 ID 不合法"),
    E9001027(9001027L,"页面参数不合法"),
    E9001028(9001028L,"一次删除页面 ID 数量不能超过 10"),
    E9001029(9001029L,"页面已应用在设备中，请先解除应用关系再删除"),
    E9001030(9001030L,"一次查询页面 ID 数量不能超过 50"),
    E9001031(9001031L,"时间区间不合法"),
    E9001032(9001032L,"保存设备与页面的绑定关系参数错误"),
    E9001033(9001033L,"门店 ID 不合法"),
    E9001034(9001034L,"设备备注信息过长"),
    E9001035(9001035L,"设备申请参数不合法"),
    E9001036(9001036L,"查询起始值 begin 不合法"),
    ;
    private Long code;
    private String desc;

    WxErrorCodeEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Long,WxErrorCodeEnum> valueMap = new HashMap<>();

    static {
        for (WxErrorCodeEnum value : WxErrorCodeEnum.values()) {
            valueMap.put(value.getCode(),value);
        }
    }

    public Long getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static WxErrorCodeEnum getByCode(Long code){
        if(Objects.isNull(code)){
            return null;
        }
        WxErrorCodeEnum wxErrorCodeEnum = valueMap.get(code);
        if (Objects.isNull(wxErrorCodeEnum)){
            log.warn("wx error code miss {}",code);
            return WxErrorCodeEnum.E_10000;
        }
        return wxErrorCodeEnum;
    }


}
