package cn.com.duiba.duiba.qutui.center.api.remoteservice.mpAuth;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.OaUserInfoResultDto;
import cn.com.duiba.duiba.qutui.center.api.dto.auth.OaUserTokenResultDto;

/**
 * 根据静默授权的code，获取userToken
 * userToken ： 参数access_token。由于公众号API鉴权的参数也叫access_token，为了区分这里叫userToken
 * @author xiaotian
 * @date 2020/11/19 9:19 下午
 */
@AdvancedFeignClient
public interface RemoteOaAuthService {
    /**
     * 根据用户静默授权的code，获取userToken,和openId
     * @param oaId 公众号ID
     * @param code 静默授权code
     */
    OaUserTokenResultDto getUserTokenByCode(Long oaId, String code);

    /**
     * 手动授权后，根据token获取userInfo
     * @param userToken 用户静默授权code换取的access_token
     * @param openId 用户静默授权后可获得
     */
    OaUserInfoResultDto getUserInfoByToken(String userToken, String openId);

    /**
     * 当用户的access_token失效后，可根据refresh_token获取一个新的access_token
     * @param refreshToken 用户静默授权获得access_token的同时可以获取到一个refreshToken
     * @param oaId 授权公众号ID
     */
    OaUserTokenResultDto refreshToken(String refreshToken, Long oaId);


    /**
     * 根据oaID获取公众号的js api ticket。
     * @param oaId 公众号ID
     * @return 公众号页面js授权ticket。
     */
    String getTicketWithCache(Long oaId);




    /**
     * 根据用户静默授权的code，获取userToken,和openId
     * @param oaId 公众号ID
     * @param code 静默授权code
     */
    OaUserTokenResultDto getComponentUserTokenByCode(Long oaId, String code);


    /**
     * 当用户的access_token失效后，可根据refresh_token获取一个新的access_token
     * @param refreshToken 用户静默授权获得access_token的同时可以获取到一个refreshToken
     * @param oaId 授权公众号ID
     */
    OaUserTokenResultDto componentRefreshToken(String refreshToken, Long oaId);
}
