package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.enums.MiddlePageTypeEnum;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import cn.com.duiba.duiba.qutui.center.api.util.Assert;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectMiddlePageDto.java
 * @Description TODO
 * @createTime 2021年03月21日 11:25:00
 */
@Data
public class ProjectMiddlePageDto implements Serializable {
    /**
     * 中间页形式:0:实体中间页 1:空白中间页 2:关注公众号中间页
     */
    private Integer middlePageType;
    /**
     * 是否自动添加绑定关系0:否 1:是
     */
    private Integer autoBandRelation;
    /**
     * 关注自动回复
     */
    private String replyContent;
    /**
     * 关注跳转的活动链接
     */
    private String jumpUrl;
    /**
     * 事件id
     */
    private Long eventId;

    public void check() throws BizException {
        Assert.isNotNull(middlePageType, ErrorCode.PARAM_ERROR, "请选择中间页形式");
        Assert.isNotNull(autoBandRelation, ErrorCode.PARAM_ERROR, "请选择绑定关系");

        if (MiddlePageTypeEnum.SUBSCRIBE.getCode().equals(middlePageType)) {
            Assert.isNotEmpty(jumpUrl, ErrorCode.PARAM_ERROR, "请选择关注跳转的活动链接");
            Assert.isNotNull(eventId, ErrorCode.PARAM_ERROR, "请选择关注公众号绑定的事件");
        }

    }
}
