package cn.com.duiba.duiba.qutui.center.api.dto.task;

import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName EventResultData.java
 * @Description 业绩计算
 * @createTime 2021年03月18日 20:20:00
 */
@Data
public class EventResultDto implements Serializable {

    /**
     * 沿用绑定关系
     */
    public static final Integer BAND_RELATION = 1;
    /**
     * 不沿用绑定关系
     */
    public static final Integer NOT_BAND_RELATION = 0;
    /**
     * 统计规则:完成人数
     */
    public static final Integer STATISTICAL_RULE_PEOPLE_JOIN = 0;
    /**
     * 统计规则:完成次数
     */
    public static final Integer STATISTICAL_RULE_COUNT = 1;
    /**
     * 参与且完成
     */
    public static final Integer FINISH_TYPE_1 = 1;
    /**
     * 参与即完成
     */
    public static final Integer FINISH_TYPE_2 = 2;

    /**
     * 完成方式
     */
    private Integer finishType;

    /**
     * 统计规则:0:完成人数;1:完成次数
     */
    private Integer statisticalRule;
    /**
     * 沿用绑定关系:0不沿用 1:沿用
     */
    private Integer bandRelation;

    public String check() {
        if (finishType == null) {
            return "请选择完成方式";
        }
        if (statisticalRule == null) {
            return "请选择统计规则";
        }
        if (bandRelation == null) {
            return "请选择沿用绑定关系";
        }
        return null;
    }


}
