package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.enums.ProjectPushTypeEnum;
import cn.com.duiba.duiba.qutui.center.api.enums.ProjectStatusEnum;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import cn.com.duiba.duiba.qutui.center.api.util.Assert;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 项目表
 * 2021-3-19 15:09:43
 */
@Data
public class ProjectDto implements Serializable {

    /**
     * 事件id,主键，自增
     */
    private Long id;

    /**
     * 创建机构id
     */
    private Long setupId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目显示名称
     */
    private String projectTxt;

    /**
     * 项目有效期开始时间
     */
    private Date startTime;

    /**
     * 项目有效期结束时间
     */
    private Date endTime;

    /**
     * 状态，0：下架 1：上架
     */
    private Integer projectStatus;

    /**
     * 项目简介
     */
    private String projectContext;

    /**
     * 推广类型
     */
    private Integer pushType;

    /**
     * 活动地址
     */
    private String activityUrl;

    /**
     * 推广海报，json格式
     */
    private String pushJson;

    /**
     * 中间页配置，json格式
     */
    private String middlePageConfig;

    /**
     * 通知内容
     */
    private String notifyContent;

    /**
     * 通知内容
     */
    private String notifyContentText;

    /**
     * 创建者id
     */
    private Long createId;

    /**
     * 修改者id
     */
    private Long modifiedId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 推广角色
     */
    private String staffType;

    /**
     * 删除标记 0：未删除 1：已删除
     */
    private Integer delFlag;

    /**
     * 置顶参数
     */
    private Integer topNum;


    /**
     * 项目校验
     *
     * @param isSave 是否是保存
     * @throws BizException
     */
    public void check(boolean isSave) throws BizException {
        Assert.isNotBlank(projectName, ErrorCode.PARAM_ERROR, "项目名称不能为空!");

        if(StringUtils.isBlank(projectTxt)){
            projectTxt = "";
        }
        if(StringUtils.isBlank(projectContext)){
            projectContext = "";
        }

        if(ProjectPushTypeEnum.URL.equals(pushType)){
            Assert.isNotBlank(projectTxt, ErrorCode.PARAM_ERROR, "项目显示名称不能为空!");
            Assert.isNotBlank(projectContext, ErrorCode.PARAM_ERROR, "项目简介不能为空!");
        }
        Assert.isNotNull(startTime, ErrorCode.PARAM_ERROR, "项目有效期开始时间不能为空!");
        long currentTime = DateUtils.getDayDate(new Date()).getTime();
        Assert.isNotNull(endTime, ErrorCode.PARAM_ERROR, "项目有效期结束时间不能为空!");
        Assert.isTrue(endTime.getTime() >= currentTime, ErrorCode.PARAM_ERROR, "项目有效期结束时间必须大于当前时间!");
        Assert.isTrue(startTime.getTime() < endTime.getTime(), ErrorCode.PARAM_ERROR, "项目有效期开始时间必须小于结束时间!");
//        ProjectStatusEnum status = ProjectStatusEnum.getEnum(projectStatus);
//        Assert.isNotNull(status, ErrorCode.PARAM_ERROR, "状态错误!");
        Assert.isNotBlank(activityUrl, ErrorCode.PARAM_ERROR, "活动地址不能为空!");
        Assert.isNotBlank(getPushJson(), ErrorCode.PARAM_ERROR, "推广海报不能为空!");

        if (isSave) {
            Assert.isTrue(startTime.getTime() >= currentTime, ErrorCode.PARAM_ERROR, "项目有效期开始时间必须大于当前时间!");
            ProjectPushTypeEnum projectPushTypeEnum = ProjectPushTypeEnum.getEnum(pushType);
            Assert.isNotNull(projectPushTypeEnum, ErrorCode.PARAM_ERROR, "推广类型错误!");
            ProjectMiddlePageDto projectMiddlePageDto = getProjectMiddlePageDto();
            Assert.isNotNull(projectMiddlePageDto, ErrorCode.PARAM_ERROR, "中间页配置不能为空!");
            projectMiddlePageDto.check();
        }
    }


    public Object getProjectPushJsonDtos(){
        ProjectPushTypeEnum projectPushTypeEnum = ProjectPushTypeEnum.getEnum(pushType);
        if(projectPushTypeEnum==null || ProjectPushTypeEnum.URL == projectPushTypeEnum){
            return getPushJson();
        }
        try {
            return JSONArray.parseArray(getPushJson(), ProjectPushJsonDto.class);
        } catch (Exception e) {

        }
        return null;
    }

    public ProjectMiddlePageDto getProjectMiddlePageDto(){
        try {
            return JSON.parseObject(getMiddlePageConfig(),ProjectMiddlePageDto.class);
        } catch (Exception e) {

        }
        return null;
    }
}

