package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.enums.ProjectStatusEnum;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import cn.com.duiba.duiba.qutui.center.api.util.Assert;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ProjectPushJsonDto.java
 * @Description 项目推广海报
 * @createTime 2021年03月21日 11:01:00
 */
@Data
public class ProjectPushJsonDto implements Serializable {

    /**
     * 图片地址
     */
    private String image;
    /**
     * 上下架状态 0:下架 1:上架
     */
    private Integer status;
    /**
     * 排序规则
     */
    private Integer sort;
    /**
     * 显示文案
     */
    private String context;

    /**
     * 二维码位置
     */
    @JSONField(name = "customQRCode")
    private ProjectPushJsonCustomQRCodeDto customQRCode;

    public void check() throws BizException {
        Assert.isNotBlank(image, ErrorCode.PARAM_ERROR,"图片不能为空");
        ProjectStatusEnum statusEnum = ProjectStatusEnum.getEnum(status);
        Assert.isNotNull(statusEnum,ErrorCode.PARAM_ERROR,"状态不能为空");
    }

}
