package cn.com.duiba.duiba.qutui.center.api.dto.task;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 部门表
* 2021-6-28 13:44:24
*/
@Data
public class SysDeptDto implements Serializable {

    /**
    * 部门id
    */
    private Long deptId;

    /**
    * 父部门id
    */
    private Long parentId;

    /**
    * 祖级列表
    */
    private String deptAncestors;

    /**
    * 部门名称
    */
    private String deptName;

    /**
    * 显示顺序
    */
    private Integer orderNum;

    /**
    * 负责人
    */
    private String deptLeader;

    /**
    * 联系电话
    */
    private String deptPhone;

    /**
    * 邮箱
    */
    private String deptEmail;

    /**
    * 部门状态（0正常 1停用）
    */
    private String deptStatus;

    /**
    * 删除标志（0代表存在 2代表删除）
    */
    private String delFlag;

    /**
    * 创建者
    */
    private String createBy;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新者
    */
    private String modifiedBy;

    /**
    * 更新时间
    */
    private Date gmtModified;

    /**
    * 企业信息id
    */
    private Long wcaId;

    public SysDeptDto(){

    }

    public SysDeptDto(Long wcaId){
        this.wcaId = wcaId;
        this.deptLeader = "admin";
        this.deptEmail = "xx@qq.com";
        this.createBy = "admin";
        this.modifiedBy = "admin";
        this.deptName = "总公司";
        this.deptPhone = "15888888888";
    }


}

