package cn.com.duiba.duiba.qutui.center.api.dto.task;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 角色信息表
* 2021-6-28 13:41:43
*/
@Data
public class SysRoleDto implements Serializable {

    /**
    * 角色ID
    */
    private Long roleId;

    /**
    * 角色名称
    */
    private String roleName;

    /**
    * 角色权限字符串
    */
    private String roleKey;

    /**
    * 显示顺序
    */
    private Integer roleSort;

    /**
    * 数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）
    */
    private String dataScope;

    /**
    * 角色状态（0正常 1停用）
    */
    private String roleStatus;

    /**
    * 删除标志（0代表存在 2代表删除）
    */
    private String delFlag;

    /**
    * 创建者
    */
    private String createBy;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新者
    */
    private String modifiedBy;

    /**
    * 更新时间
    */
    private Date gmtModified;

    /**
    * 备注
    */
    private String roleRemark;

    /**
    * 企业Id
    */
    private Long wcaId;


    public SysRoleDto(){

    }

    public SysRoleDto(Long wcaId){
        this.wcaId = wcaId;
        this.roleRemark = "超级管理员";
        this.createBy = "admin";
        this.modifiedBy = "admin";
        this.roleName = "超级管理员";
        this.roleStatus = "0";
        this.roleSort = 1;
        this.roleKey = "admin";
        this.delFlag = "1";
    }

}

