package cn.com.duiba.duiba.qutui.center.api.dto.users;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 授权用户信息表
* 2021-4-20 16:54:10
*/
@Data
public class UsersDto implements Serializable {

    /*
     * 自有用户
     */
    public static final Integer user_type_self = 0;
    /*
     * 机构用户
     */
    public static final Integer user_type_setup = 1;


    /**
    * 主键
    */
    private Long id;

    /**
    * 小程序id
    */
    private Long mpId;

    /**
    * 用户的标识，对当前公众号唯一
    */
    private String openId;

    /**
    * 用户的昵称
    */
    private String nickName;

    /**
    * 用户性别，1=男性，2=女性，0=未知
    */
    private Integer userGender;

    /**
    * 用户的头像
    */
    private String userAvatar;

    /**
    * 手机国家code
    */
    private String phoneCountryCode;

    /**
    * 用户所在国家
    */
    private String userCountry;

    /**
    * 用户所在省
    */
    private String userProvince;

    /**
    * 用户所在市
    */
    private String userCity;

    /**
    * 微信用户的语言
    */
    private String userLang;

    /**
    * 用户手机号
    */
    private String phoneNum;

    /**
    * 微信接口返回 access_token，用户解密敏感数据, 小程序为session_key
    */
    private String accessToken;

    /**
    * 微信接口返回 refresh_token
    */
    private String refreshToken;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;

    /**
    * 用户类型0：自有用户 1：机构用户
    */
    private Integer userType;

    /**
    * 是否关注 0:关注 1:取关
    */
    private Integer userSubscribe;

    /**
    * 关注时间
    */
    private Date subscribeTime;

    /**
    * 微信的unionId
    */
    private String unionId;


}

