package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.task.GradeSortDto;
import cn.com.duiba.duiba.qutui.center.api.param.task.GetGradeSortListParam;
import cn.com.duiba.duiba.qutui.center.api.result.PageResult;
import cn.com.duiba.duiba.qutui.center.api.result.task.SortResult;

/**
*  RemoteService
* @author xiaotian
* 2021-4-21 13:43:45
*/
@AdvancedFeignClient
public interface RemoteGradeSortService {
    /**
    * 新增记录
    */
	Boolean save(GradeSortDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(GradeSortDto dto);
    /**
    * 根据id获取
    */
    GradeSortDto getById(Long id);

    SortResult<GradeSortDto> getGradeSortList(GetGradeSortListParam param) throws BizException;

    PageResult<GradeSortDto> getGradeSortListAdmin(GetGradeSortListParam param) throws BizException;


}
